<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class ConveyancingAdvocate extends Model
{
    //
    use HasFactory,SoftDeletes;
    protected $table = 'conveyancing_advocate';

    protected $fillable = [
        'conveyancing_id',
        'advocate_id',
        'role',//lead | assistant 
    ];

    //relationship with advocates
    public function advocate():BelongsTo{
        return $this->belongsTo(Advocate::class);
    }

    //relationship with conveyancing
    public function conveyancing():BelongsTo{
        return $this->belongsTo(Conveyancing::class);
    }

    
}
