<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApartmentDetail extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = ["project_id", "project_client_id", "floor", "flat_name","amount_charged", "owner2", "unit_type"];

    //relationship with projects
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    //relationship with project client
    public function projectClient(): BelongsTo
    {
        return $this->belongsTo(ProjectClient::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (!$model->project_id && $model->projectClient) {
                $model->project_id = $model->projectClient->project_id;
            }
        });
    }


}


