<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Advocate extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = ['user_id', 'license_number', 'specialization', 'phone', 'national_id', 'address'];

    //relationship bwteen advocate and user
    public function user()
    {
        return $this->belongsTo(User::class);
    }


    //relationship with conveyancing
    public function conveyancingCases()
    {
        return $this->belongsToMany(Conveyancing::class, 'conveyancing_advocate')
            ->withPivot('role')
            ->withTimestamps();
    }

    //relationship with conveyancingAdvocates
    public function conveyancingAdvocates():HasMany{
        return $this->hasMany(ConveyancingAdvocate::class);
    }
}
