<?php

namespace App\Mail;

use App\Models\Payment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Attachment;
use Barryvdh\DomPDF\Facade\Pdf;


class DepositReceiptMail extends Mailable
{
    use Queueable, SerializesModels;

    public Payment $payment;
    /**
     * Create a new message instance.
     */
    public function __construct(Payment $payment)
    {
        //
        $this->payment = $payment;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Deposit #' . $this->payment->id,        
        );
        
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
           view: 'emails.receipt', // Make sure this file exists
            with: [
                'payment' => $this->payment,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
       $pdf = Pdf::loadView('pdf.receipt', [
            'payment' => $this->payment,
        ]);
        return [
            Attachment::fromData(
                fn () => $pdf->output(),
                'payment-' . $this->payment->id . '.pdf'
            )->withMime('application/pdf'),
        ];
    }
}
