<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RestrictToAdminsWithRedirect
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!Auth::check()) {
            // If user is not authenticated, redirect to login
            return redirect()->route('login')->with('error', 'Please log in to access the admin panel.');
        }

        if (Auth::user()->hasAnyRole(['admin', 'Super Admin'])) {
            // User has Admin or Super Admin role, allow access
            return $next($request);
        }

        // Authenticated user without Admin or Super Admin role, redirect to normal dashboard
        return redirect()->route('dashboard')->with('error', 'You do not have permission to access the admin panel.');
    }
}
