<?php
namespace App\Filament\Resources\UserResource\Pages;

use Filament\Actions;
use App\Filament\Resources\UserResource;
use Filament\Actions\Action;
use Filament\Infolists\Components\ViewEntry;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Infolist;
use Filament\Infolists\Components\Section;

class ViewUser extends ViewRecord
{
    protected static string $resource = UserResource::class;

    protected function getHeaderActions(): array
    {
        return [
           Action::make('edit')
                ->label('Edit')
                ->icon('heroicon-o-pencil')
                ->url(fn() => UserResource::getUrl('edit', ['record' => $this->record])),
 

        ];
    }

    //section that shows all user records
    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Section::make('User Details')->schema([
                    ViewEntry::make('userDetails')
                        ->view('infolists.user-components.view-user')
                        ->viewData([
                            'record' => $this->record
                        ]),
                ]),
            ]);
    }


}
