<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Resources\Pages\EditRecord;
use Filament\Actions\Action;
use Filament\Actions\DeleteAction;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class EditUser extends EditRecord
{
    protected static string $resource = UserResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('view')
                ->label('View')
                ->url(fn () => UserResource::getUrl('view', ['record' => $this->record]))
                ->color('gray')
                ->icon('heroicon-o-eye'),
            DeleteAction::make()
                ->label('Delete')
                ->requiresConfirmation()
                ->icon('heroicon-o-trash'),

            //for changing password
             Action::make('changePassword')
            ->label('Change Password')
            ->icon('heroicon-o-key')
            ->url(fn () => static::getResource()::getUrl('change-password', ['record' => $this->record])),
  
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Handle password: only update if provided
        if (empty($data['password'])) {
            unset($data['password']);
        }

        return $data;
    }

    protected function afterSave(): void
    {
        $user = $this->record;

        // Sync roles
         if (!empty($this->data['role']) && Role::where('name', $this->data['role'])->exists()) {
        $user->syncRoles([$this->data['role']]);
    } else {
        $user->syncRoles([]);
    }

        // Sync permissions
        $permissions = [];
        if (isset($this->data['permissions']) && is_array($this->data['permissions'])) {
            foreach ($this->data['permissions'] as $resourcePermissions) {
                if (is_array($resourcePermissions)) {
                    $permissions = array_merge($permissions, $resourcePermissions);
                }
            }
            $user->permissions()->sync($permissions);
        } else {
            $user->permissions()->sync([]);
        }

        // Handle role-specific related models
        $role = $this->data['role'] ?? null;

        if ($role === 'client') {
            $user->client()->updateOrCreate([], [
                'phone' => $this->data['client_phone'] ?? null,
                'national_id' => $this->data['client_national_id'] ?? null,
                'address' => $this->data['client_address'] ?? null,
                'kra_pin' =>$data['kra_pin']??null,
                'passport_number' => $data['passport_number']??null,
                'nationality' => $data['nationality']?? null,
                'identification_image' => $data['identification_image']??null

            ]);
            $user->advocate()->delete();
        }

        if ($role === 'advocate') {
            $user->advocate()->updateOrCreate([], [
                'license_number' => $this->data['advocate_license_number'] ?? null,
                'specialization' => $this->data['advocate_specialization'] ?? null,
                'phone' => $this->data['advocate_phone'] ?? null,
                'national_id' => $this->data['advocate_national_id'] ?? null,
                'address' => $this->data['advocate_address'] ?? null,
            ]);
            $user->client()->delete();
        }
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Populate role-specific form fields for editing
        if ($this->record->client) {
            $data['role'] = 'client';
            $data['client_phone'] = $this->record->client->phone;
            $data['client_national_id'] = $this->record->client->national_id;
            $data['client_address'] = $this->record->client->address;
            $data['kra_pin'] = $this->record->client->kra_pin;
            $data['passport_number'] = $this->record->client->passport_number;
            $data['nationality'] = $this->record->client->nationality;
            $data['identification_image'] = $this->record->identification_image;
        }

        if ($this->record->advocate) {
            $data['role'] = 'advocate';
            $data['advocate_license_number'] = $this->record->advocate->license_number;
            $data['advocate_specialization'] = $this->record->advocate->specialization;
            $data['advocate_phone'] = $this->record->advocate->phone;
            $data['advocate_national_id'] = $this->record->advocate->national_id;
            $data['advocate_address'] = $this->record->advocate->address;
        }

        return $data;
    }

    //redirect after edit
      protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
}
