<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;
use \Spatie\Permission\Models\Role;
use Filament\Actions;


class CreateUser extends CreateRecord
{
    protected static string $resource = UserResource::class;

    protected function handleRecordCreation(array $data): Model
    {
        $user = static::getModel()::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => $data['password'],
            'username' => $data['username']
        ]);

        // Sync roles
        if (isset($data['role'])) {
            if (Role::where('name', $data['role'])->exists()) {
                $user->assignRole($data['role']);
            }
        }

        // Sync permissions
        $permissions = [];
        if (isset($data['permissions']) && is_array($data['permissions'])) {
            foreach ($data['permissions'] as $resourcePermissions) {
                if (is_array($resourcePermissions)) {
                    $permissions = array_merge($permissions, $resourcePermissions);
                }
            }
            $user->permissions()->sync($permissions);
        }

        // Create related model based on role
        if (($data['role'] ?? null) === 'client') {
            $user->client()->create([
                'phone' => $data['client_phone'],
                'national_id' => $data['client_national_id'],
                'address' => $data['client_address'] ?? null,
                'kra_pin' =>$data['kra_pin']??null,
                'passport_number' => $data['passport_number']??null,
                'nationality' => $data['nationality']?? null,
                'identification_image' => $data['identification_image']??null
            ]);
        }

        if (($data['role'] ?? null) === 'advocate') {
            $user->advocate()->create([
                'license_number' => $data['advocate_license_number'] ?? null,
                'specialization' => $data['advocate_specialization'] ?? null,
                'phone' => $data['advocate_phone'] ?? null,
                'national_id' => $data['advocate_national_id'] ?? null,
                'address' => $data['advocate_address'] ?? null,
            ]);
        }

        return $user;
    }

    //redirect after create
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }

     protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }
}
