<?php

namespace App\Filament\Resources\SalaryResource\Pages;

use App\Filament\Resources\SalaryResource;
use Filament\Actions;
use Filament\Actions\Action;
use Filament\Infolists\Components\ViewEntry;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Components\Section;
use Barryvdh\DomPDF\Facade\Pdf;



class ViewSalary extends ViewRecord
{
    protected static string $resource = SalaryResource::class;

    //get haeder actions 
    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
            Action::make('download_pdf')
                ->label('Download PDF')
                ->action(function ($record) {
                    // Generate the PDF
                    $pdf = Pdf::loadView('pdf.salary', [
                        'salary' => $record,
                    ]);

                    // Download the PDF
                    return response()->streamDownload(function () use ($pdf) {
                        echo $pdf->output();
                    }, 'salary-' . $record->id . '.pdf');
                })
                ->icon('heroicon-o-arrow-down-tray')
                ->color('primary'),
        ];
    }

    //function to create infolist
    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist->schema([
            Section::make('Salary')->schema([
                ViewEntry::make('salary')
                    ->view('infolists.salary-components.salary-details')
                    ->viewData([
                        'salary' => $this->record
                    ])
            ]),
        ]);
    }
}