<?php

namespace App\Filament\Resources\PermissionResource\Pages;

use App\Filament\Resources\PermissionResource;
use Filament\Actions;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\ViewEntry;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;

class ViewPermission extends ViewRecord
{
    protected static string $resource = PermissionResource::class;

    protected function getHeaderActions(): array
    {
        return [
        ];
    }

    public function infolist(Infolist $infolist):Infolist{
        return $infolist->schema([
            Section::make('Permission Details')->schema([
                ViewEntry::make('permissionDetails')
                 ->view('infolists.permission-components.view-permission')
                 ->viewData([
                    'record'=>$this->record
                 ])
            ]),
        ]);
    }
}
