<?php

namespace App\Filament\Resources\PaymentResource\Pages;

use App\Filament\Resources\PaymentResource;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;

class ViewPayment extends ViewRecord
{
    protected static string $resource = PaymentResource::class;

    protected function getHeaderActions(): array
    {
        return [
            \Filament\Actions\EditAction::make(),
            \Filament\Actions\DeleteAction::make(),
        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Section::make('Payment Details')
                    ->schema([
                        TextEntry::make('payable_type')
                            ->label('Payment Type')
                            ->formatStateUsing(fn (?string $state): string => $state ? str_replace('App\\Models\\', '', $state) : 'N/A'),
                        TextEntry::make('payable_id')
                            ->label('Related Entity')
                            ->formatStateUsing(function ($state, $record): string {
                                if ($record->payable_type === 'App\Models\Salary' && $record->payable) {
                                    return $record->payable->employee->name . ' (' . ($record->payable->period ?? 'No Period') . ')';
                                } elseif ($record->payable_type === 'App\Models\OfficeUtility' && $record->payable) {
                                    return $record->payable->type . ' (' . ($record->payable->period ?? 'No Period') . ')';
                                }
                                return $state ?: 'N/A';
                            }),
                        TextEntry::make('amount')
                            ->label('Amount')
                            ->money('KES', true)
                            ->default('0.00'),
                        TextEntry::make('payment_method')
                            ->label('Payment Method')
                            ->formatStateUsing(fn (?string $state): string => $state ? ucfirst($state) : 'N/A'),
                        TextEntry::make('transaction_id')
                            ->label('Transaction ID')
                            ->default('N/A'),
                        TextEntry::make('status')
                            ->label('Status')
                            ->badge()
                            ->color(fn (?string $state): string => match ($state) {
                                'pending' => 'warning',
                                'completed' => 'success',
                                'failed' => 'danger',
                                default => 'secondary',
                            })
                            ->formatStateUsing(fn (?string $state): string => $state ? ucfirst($state) : 'N/A'),
                        TextEntry::make('created_at')
                            ->label('Created At')
                            ->dateTime('d M Y H:i')
                            ->default('N/A'),
                    ])
                    ->columns(2),
            ]);
    }
}