<?php

namespace App\Filament\Resources\PaymentResource\Pages;

use App\Filament\Resources\PaymentResource;
use App\Models\Payment;
use Filament\Resources\Pages\EditRecord;

class EditPayment extends EditRecord
{
    protected static string $resource = PaymentResource::class;

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data['direction'] = $this->record->direction;
        $data['client_id'] = null;
        return $data;
    }

    protected function afterSave(): void
    {
        $payment = $this->record;
        $data = $this->form->getState();
        $payment->update(['client_id' => null]);
    }
}