<?php

namespace App\Filament\Resources\OfficeUtilityResource\Pages;

use App\Filament\Resources\OfficeUtilityResource;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\ViewEntry;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Infolist;
use Filament\Actions;
use Filament\Actions\Action;
use Barryvdh\DomPDF\Facade\Pdf;

class ViewOfficeUtility extends ViewRecord
{
    protected static string $resource = OfficeUtilityResource::class;

    protected function getHeaderActions(): array{
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
            //where to add download button
            Action::make('download_pdf')
                ->label('Download PDF')
                ->action(function ($record) {
                    // Generate the PDF
                    $pdf = Pdf::loadView('pdf.office-utility', [
                        'officeutility' => $record,
                    ]);

                    // Download the PDF
                    return response()->streamDownload(function () use ($pdf) {
                        echo $pdf->output();
                    }, 'office-utility-' . $record->id . '.pdf');
                })
                ->icon('heroicon-o-arrow-down-tray')
                ->color('primary'),
        ];
    }

    public function infolist(Infolist $infolist): Infolist{
        return $infolist->schema([
           Section::make('Office Utilities')->schema([
               ViewEntry::make('officeutility')
               ->view('infolists.office-utility-components.office-utility-details')
               ->viewData([
                  'officeutility'=>$this->record
               ])
           ])
        ]);
    }
}