<?php

namespace App\Filament\Resources;

use App\Filament\Resources\OfficeUtilityResource\Pages;
use App\Filament\Resources\OfficeUtilityResource\RelationManagers;
use App\Models\OfficeUtility;
use Filament\Forms;
use Filament\Forms\Components\Select;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;

class OfficeUtilityResource extends Resource
{
    protected static ?string $model = OfficeUtility::class;

    protected static ?string $navigationIcon = 'heroicon-o-home-modern';

    protected static ?string $navigationGroup = 'Financial Management';

    protected static ?string $navigationLabel = 'Office Utilities';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('Utility Details')
                    ->schema([
                        TextInput::make('type')
                            ->label('Utility Name (e.g., Electricity, Rent)')
                            ->required()
                            ->maxLength(255),
                        TextInput::make('amount')
                            ->numeric()
                            ->required()
                            ->prefix('KSh')
                            ->minValue(0),
                        Select::make('period')
                            ->label('Period')
                            ->options([
                                'Monthly' => 'Monthly',
                                'Quarterly' => 'Quarterly',
                                'Yearly' => 'Yearly',
                            ])
                            ->required(),
                    ])
                    ->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('type')
                    ->label('Utility Name')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('amount')
                    ->money('KES')
                    ->sortable(),
                TextColumn::make('period')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()->latest();
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOfficeUtilities::route('/'),
            'create' => Pages\CreateOfficeUtility::route('/create'),
            'edit' => Pages\EditOfficeUtility::route('/{record}/edit'),
            'view' => Pages\ViewOfficeUtility::route('/{record}'),
        ];
    }
}