<?php

namespace App\Filament\Resources\LitigationResource\Pages;

use App\Filament\Resources\LitigationResource;
use Filament\Actions\Action;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditLitigation extends EditRecord
{
    protected static string $resource = LitigationResource::class;

    protected function getHeaderActions(): array
    {
        return [
           Action::make('view')
                ->label('View')
                ->url(fn () => LitigationResource::getUrl('view', ['record' => $this->record]))
                ->color('gray')
                ->icon('heroicon-o-eye'),
            DeleteAction::make()
                ->label('Delete')
                ->requiresConfirmation()
                ->icon('heroicon-o-trash'),
        ];
    }

     //redirect after edit
      protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
}
