<?php

namespace App\Filament\Resources\LitigationResource\Pages;

use App\Filament\Resources\LitigationResource;
use App\Models\Litigation;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateLitigation extends CreateRecord
{
  protected static string $resource = LitigationResource::class;

  
  //redirect after creation 
  protected function getRedirectUrl(): string
  {
    return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
  }
     protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }
}