<?php

namespace App\Filament\Resources\InvoiceResource\Pages;

use App\Filament\Resources\InvoiceResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateInvoice extends CreateRecord
{
    protected static string $resource = InvoiceResource::class;

      protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }
    

    //save and create another
    


    //redirect after creating
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
}
