<?php

namespace App\Filament\Resources\ExpenseResource\Pages;

use App\Filament\Resources\ExpenseResource;
use Filament\Actions\Action;
use Filament\Infolists\Components\ViewEntry;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Components\Section;
use Barryvdh\DomPDF\Facade\Pdf;


use Filament\Actions;

class ViewExpense extends ViewRecord
{
    protected static string $resource = ExpenseResource::class;


    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
            //pdf development link 
            Action::make('downloadExpense')
                ->label('Download Expense')
                ->icon('heroicon-o-arrow-down-tray')
                ->color('success')
                ->action(function () {
                    // Make sure related model (e.g. expensable) is loaded if needed
                    $this->record->loadMissing('expensable'); // optional
        
                    // Generate the PDF using your expense view
                    $pdf = Pdf::loadView('pdf.expense', [
                        'expense' => $this->record,
                    ]);

                    return response()->streamDownload(
                        fn() => print ($pdf->stream()),
                        'expense-' . $this->record->id . '.pdf'
                    );
                })


        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist->schema([
            Section::make('Funds Released')
                ->schema([
                    ViewEntry::make('expense')
                        ->view('infolists.expense-components.expense-details')
                        ->viewData([
                            'expense' => $this->record,
                        ]),
                ]),
        ]);
    }
}
