<?php

namespace App\Filament\Resources\ExpenseResource\Pages;

use App\Filament\Resources\ExpenseResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;
class CreateExpense extends CreateRecord
{
    protected static string $resource = ExpenseResource::class;

    protected function handleRecordCreation(array $data): \Illuminate\Database\Eloquent\Model
    {
        return ExpenseResource::create($data, true);
    }

    //redirect after creation
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }

      protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }
}