<?php

namespace App\Filament\Resources\DepositResource\Pages;

use App\Filament\Resources\DepositResource;
use App\Mail\DepositReceiptMail;
use App\Models\Payment;
use Filament\Infolists\Components\ViewEntry;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;
use Filament\Actions\Action;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Mail;
use Filament\Notifications\Notification;


class ViewDeposit extends ViewRecord
{
    protected static string $resource = DepositResource::class;

    protected function getHeaderActions(): array
    {
        return [
            \Filament\Actions\EditAction::make(),
            \Filament\Actions\DeleteAction::make(),
            Action::make('downloadReceipt')
                ->label('Download Receipt')
                ->icon('heroicon-o-arrow-down-tray')
                ->color('success')
                ->action(function () {
                    // Ensure client and user are loaded
                    $this->record->loadMissing('client.user');

                    // Generate the PDF
                    $pdf = Pdf::loadView('pdf.receipt', [
                        'payment' => $this->record,
                    ]);

                    // Return a streamed download
                    return response()->streamDownload(
                        fn () => print($pdf->stream()),
                        'receipt-' . $this->record->id . '.pdf'
                    );
                }),
            //email receipt
            Action::make('send_receipt')
                ->label('Send Receipt')
                ->icon('heroicon-m-paper-airplane')
                ->requiresConfirmation()
                ->action(function (Payment $record) {
                    // Ensure client exists and has an email
                    if (!$record->client || !$record->client->user || !$record->client->user->email) {
                        Notification::make()
                            ->title('Client email not found.')
                            ->danger()
                            ->send();
                        return;
                    }

                    // Send email
                    Mail::to($record->client->user->email)->send(new DepositReceiptMail($record));

                    // Show success notification
                    Notification::make()
                        ->title('Receipt sent successfully to ' . $record->client->user->email)
                        ->success()
                        ->send();
                }),    
        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist->schema([
             Section::make('Payment Information')
                ->schema([
                    ViewEntry::make('payment')
                        ->view('infolists.payment-components.payment-details')
                        ->viewData([
                            'payment' => $this->record,
                        ]),
                ]),
        ]);
        
           
    }

    //function to gnerate receipt

}