<?php

namespace App\Filament\Resources\DepositResource\Pages;

use App\Filament\Resources\DepositResource;
use App\Models\ConveyancingPayment;
use App\Models\LitigationPayment;
use App\Models\Payment;
use App\Models\ProjectClientPayment;
use App\Models\ProjectClient;
use Filament\Resources\Pages\EditRecord;

class EditDeposit extends EditRecord
{
    protected static string $resource = DepositResource::class;

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data['direction'] = $this->record->direction;
        return $data;
    }

    protected function afterSave(): void
    {
        $payment = $this->record;
        $data = $this->form->getState();

        if ($payment->payable_type === 'App\Models\Project') {
            $projectClient = ProjectClient::where('project_id', $data['payable_id'])
                ->where('client_id', $data['client_id'])
                ->first();

            if ($projectClient) {
                $projectClientPayment = ProjectClientPayment::where('payment_id', $payment->id)->first();
                if ($projectClientPayment) {
                    $projectClientPayment->update([
                        'project_client_id' => $projectClient->id,
                        'amount' => (int) $data['amount'],
                        'payment_method' => $data['payment_method'],
                        'transaction_id' => $data['transaction_id'],
                        //'status' => $data['status'],
                    ]);
                }
            }
        } elseif ($payment->payable_type === 'App\Models\Conveyancing') {
            $conveyancingPayment = ConveyancingPayment::where('payment_id', $payment->id)->first();
            if ($conveyancingPayment) {
                $conveyancingPayment->update([
                'client_id' => $data['client_id'],
                'conveyancing_id' => $data['payable_id'],
                'payment_id' => $payment->id,
                'amount_paid' => (int) $data['amount_paid'],
                'payment_method' => $data['payment_method'],
                'transaction_id' => $data['transaction_id'],
                'paid_by'=>$data['paid_by'],
                'type' => $data['type'],
                //'status' => $data['status'],
                ]);
            }
        } elseif ($payment->payable_type === 'App\Models\Litigation') {
            $litigationPayment = LitigationPayment::where('payment_id', $payment->id)->first();
            if ($litigationPayment) {
                $litigationPayment->update([
                    'client_id' => $data['client_id'],
                    'litigation_id' => $data['payable_id'],
                    'amount_paid' => (int) $data['amount_paid'],
                    'payment_method' => $data['payment_method'],
                    'transaction_id' => $data['transaction_id'],
                    //'status' => $data['status'],
                ]);
            }
        }
    }
    //redirect user after edit
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
}