<?php

namespace App\Filament\Resources\DepositResource\Pages;

use App\Filament\Resources\DepositResource;
use App\Models\ConveyancingPayment;
use App\Models\LitigationPayment;
use App\Models\Payment;
use App\Models\ProjectClientPayment;
use App\Models\ProjectClient;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;
use Filament\Actions;

class CreateDeposit extends CreateRecord
{
    protected static string $resource = DepositResource::class;

    protected static ?string $title = 'Create Incoming Payment';

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['direction'] = 'incoming';
        return $data;
    }

    protected function handleRecordCreation(array $data): Model
    {
        $payment = Payment::create($data);

        if ($data['payable_type'] === 'App\Models\Project') {
            $projectClient = ProjectClient::where('project_id', $data['payable_id'])
                ->where('client_id', $data['client_id'])
                ->first();

            if ($projectClient) {
                ProjectClientPayment::create([
                    'project_client_id' => $projectClient->id,
                    'payment_id' => $payment->id,
                    'amount_paid' => (int) $data['amount_paid'],
                    'payment_method' => $data['payment_method'],
                    'transaction_id' => $data['transaction_id'],
                    //'status' => $data['status'],
                ]);
            }
        } elseif ($data['payable_type'] === 'App\Models\Conveyancing') {
            ConveyancingPayment::create([
                'client_id' => $data['client_id'],
                'conveyancing_id' => $data['payable_id'],
                'payment_id' => $payment->id,
                'amount_paid' => (int) $data['amount_paid'],
                'payment_method' => $data['payment_method'],
                'transaction_id' => $data['transaction_id'],
                'paid_by' => $data['paid_by'],
                'type' => $data['type'],
                //'status' => $data['status'],
            ]);
        } elseif ($data['payable_type'] === 'App\Models\Litigation') {
            LitigationPayment::create([
                'client_id' => $data['client_id'],
                'litigation_id' => $data['payable_id'],
                'payment_id' => $payment->id,
                'amount_paid' => (int) $data['amount_paid'],
                'type' => $data['type'],
                'payment_method' => $data['payment_method'],
                'transaction_id' => $data['transaction_id'],
                //'status' => $data['status'],
            ]);
        }

        return $payment;
    }
    //redirect user after creation
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }

     protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }

}