<?php

namespace App\Filament\Resources\ConveyancingResource\Pages;

use App\Filament\Resources\ConveyancingResource;
use Filament\Actions\Action;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditConveyancing extends EditRecord
{
    protected static string $resource = ConveyancingResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('view')
                ->label('View')
                ->url(fn() => ConveyancingResource::getUrl('view', ['record' => $this->record]))
                ->color('gray')
                ->icon('heroicon-o-eye'),
            DeleteAction::make()
                ->label('Delete')
                ->requiresConfirmation()
                ->icon('heroicon-o-trash'),
        ];
    }


    //redirect after edit
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }

    //maintain the serial number
    protected function mutateFormDataBeforeSave(array $data): array
    {
        if ($this->record && $this->record->serial_number) {
            $data['serial_number'] = $this->record->serial_number;
        }

        return $data;
    }

}
