<?php
namespace App\Filament\Resources\ConveyancingResource\Pages;

use Illuminate\Support\Str;
use Filament\Resources\Pages\CreateRecord;
use App\Models\Conveyancing;
use Filament\Actions;
use App\Filament\Resources\ConveyancingResource;


class CreateConveyancing extends CreateRecord
{
    protected static string $resource = ConveyancingResource::class;

     protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }

    
     //redirect after create
      protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
}
