<?php

namespace App\Filament\Resources\ClientResource\Pages;

use App\Filament\Resources\ClientResource;
use App\Models\Client; // Add this import
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\DB;

class EditClient extends EditRecord
{
    protected static string $resource = ClientResource::class;

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $client = $this->record;
        $data['name'] = $client->user->name;
        $data['email'] = $client->user->email;
        return $data;
    }

    protected function handleRecordUpdate($record, array $data): Client
    {
        return DB::transaction(function () use ($record, $data) {
            // Update the User
            $record->user->update([
                'name' => $data['name'],
                'email' => $data['email'],
            ]);

            // Update the Client
            $record->update([
                'phone' => $data['phone'],
                'national_id' => $data['national_id'],
                'address' => $data['address'],
                'passport_number' =>$data['passport_number'],
                'nationality' => $data['nationality'],
                'kra_pin' =>$data['kra_pin'],
                'identification_image'=>$data['identification_image']
            ]);

            return $record;
        });
    }

    //redirect to view client details
     protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
}