<?php

namespace App\Filament\Resources\ClientResource\Pages;

use App\Filament\Resources\ClientResource;
use App\Models\User;
use App\Models\Client;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\DB;

class CreateClient extends CreateRecord
{
    protected static string $resource = ClientResource::class;

    protected function handleRecordCreation(array $data): Client
    {
        return DB::transaction(function () use ($data) {
            // Create the User
            $user = User::create([
                'name' => $data['name'],
                'email' => $data['email'],
                //'password' => $data['password'],
            ]);

            $user->assignRole('client');
            $user->markEmailAsVerified();

            // Create the Client
            return Client::create([
                'user_id' => $user->id,
                'phone' => $data['phone'],
                'national_id' => $data['national_id'],
                'address' => $data['address'],
                'passport_number' =>$data['passport_number'],
                'nationality' => $data['nationality'],
                'kra_pin' =>$data['kra_pin'],
                'identification_image'=>$data['identification_image']
            ]);
        });
    }
    //redirect user after creating
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
     protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }
}