<?php

namespace App\Filament\Resources\AdvocateResource\Pages;

use App\Filament\Resources\AdvocateResource;
use App\Models\LitigationStage;
use Filament\Actions\Action;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Infolist;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\ViewEntry;

class ViewAdvocate extends ViewRecord
{
    protected static string $resource = AdvocateResource::class;

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist->schema([

            Section::make('Advocate Information')->schema([
                ViewEntry::make('advocate')
                    ->view('infolists.advocate-components.advocate-details-table')
                    ->viewData([
                        'advocate' => $this->record,
                    ]),
            ]),

            Section::make('Assigned Litigations')->schema([
                ViewEntry::make('litigations')
                    ->view('infolists.advocate-components.advocate-litigations-table')
                    ->viewData([
                        'litigations' => $this->record->litigations ?? [],
                    ]),
            ]),

          

            //Assigned conveyancings
            Section::make('Assigned Conveyancing Cases')->schema([
                ViewEntry::make('conveyancingCases')
                    ->view('infolists.conveyancing-components.advocate-conveyancing-table')
                    ->viewData([
                        'conveyancings' => $this->record->conveyancingCases, // <-- this is correct
                    ]),
            ]),



        ]);
    }

    protected function getHeaderActions(): array
    {
        return [
            Action::make('edit')
                ->label('Edit')
                ->icon('heroicon-o-pencil')
                ->url(fn() => AdvocateResource::getUrl('edit', ['record' => $this->record])),
 
        ];
    }
}
