<?php

namespace App\Filament\Resources\AdvocateResource\Pages;

use App\Filament\Resources\AdvocateResource;
use App\Models\Advocate; // Add this import
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\DB;

class EditAdvocate extends EditRecord
{
    protected static string $resource = AdvocateResource::class;

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $advocate = $this->record;
        $data['name'] = $advocate->user->name;
        $data['email'] = $advocate->user->email;
        return $data;
    }

    protected function handleRecordUpdate($record, array $data): Advocate
    {
        return DB::transaction(function () use ($record, $data) {
            // Update the User
            $record->user->update([
                'name' => $data['name'],
                'email' => $data['email'],
            ]);

            // Update the Advocate
            $record->update([
                'license_number' => $data['license_number'],
                'specialization' => $data['specialization'],
                'address'=>$data['address'],
                'national_id'=>$data['national_id']
            ]);

            return $record;
        });
    }

    //redirect user to view clients page
     protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }
}