<?php

namespace App\Filament\Resources\AdvocateResource\Pages;

use App\Filament\Resources\AdvocateResource;
use App\Models\User;
use App\Models\Advocate;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\DB;

class CreateAdvocate extends CreateRecord
{
    protected static string $resource = AdvocateResource::class;

    protected function handleRecordCreation(array $data): Advocate
    {
        return DB::transaction(function () use ($data) {
            // Create the User
            $user = User::create([
                'name' => $data['name'],
                'email' => $data['email'],
                'password' => $data['password'],
            ]);

            $user->assignRole('advocate');
            $user->markEmailAsVerified();

            // Create the Advocate
            return Advocate::create([
                'user_id' => $user->id,
                'phone' => $data['phone'],
                'license_number' => $data['license_number'],
                'specialization' => $data['specialization'],
                'national_id' => $data['national_id'],
                'address' => $data['address'],
            ]);
        });
    }

    //redirect user after creating
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }

     protected function getFormActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->label('Save')
                ->submit('save'),

            Actions\CreateAction::make('createAnother')
                ->label('Save & Create Another')
                ->submit('save')
                ->createAnother(),

            Actions\Action::make('cancel')
                ->label('Cancel')
                ->color('primary')
                ->url(static::getResource()::getUrl('index')), // Goes back to index    
        ];
    }
}